* -----------------------------------------------------------------------------
*                                                DTT (c)2006 FSL - FreeSoftLand
*  Title: Send Mail
* 
*  Date : 25/04/2006
*  By   : Acucorp, Inc.
* -----------------------------------------------------------------------------
*
*
       IDENTIFICATION DIVISION.
       PROGRAM-ID.    Sendmail.

      * Copyright (c) 1989-2003 by Acucorp, Inc.
      * Users of ACUCOBOL may freely use this file.

       ENVIRONMENT DIVISION.

       WORKING-STORAGE SECTION.
       COPY "socket.def".

       77  SOCKET-HANDLE                      USAGE HANDLE.
       77  SERVER-NAME                        PIC X(40).
       77  DATA-RECORD                        PIC X(256).
       77  AMOUNT-READ                        PIC 9(9).
       77  NUM-TO-SEND                        PIC 9(3).
       77  FINISHED                           PIC 9(1).
       77  INPUT-CHAR                         PIC X(1).
       77  X                                  PIC 9(3).
       77  DATA-MODUS                         PIC 9(1).
       77  CRLF                               PIC X(2).

       PROCEDURE DIVISION.
       MAIN-PGH.

      *Create the lineterminator
           STRING  X"0D" X"0A"      DELIMITED BY SIZE INTO CRLF.
           DISPLAY WINDOW           ERASE.
           INITIALIZE               DATA-MODUS.

      *You should set your smtp server here:
      * You must check with your IS dept. It might be mail.yourdomain.xyz
           STRING  "smtp.yourdomain.xyz" LOW-VALUES
                   DELIMITED        BY SIZE
                   INTO             SERVER-NAME.
           CALL    "C$SOCKET"       USING
                   AGS-CREATE-CLIENT
                   25
                   SERVER-NAME
                   GIVING           SOCKET-HANDLE.

           IF      SOCKET-HANDLE    = NULL
                   DISPLAY          "Unable to connect to server..."
                   ACCEPT           OMITTED
                   STOP             RUN.

           PERFORM CHECK-SOCKET.
           DISPLAY "Connected... "  SOCKET-HANDLE CONVERT.

           INITIALIZE               DATA-RECORD.
           MOVE    1                TO NUM-TO-SEND.
      *Send hello to verify connection
      *Replace smtp.yourdomain.xyz with the one you are connected to
           STRING  "helo smtp.yourdomain.xyz"
                   CRLF            DELIMITED BY SIZE
                   INTO             DATA-RECORD
                   WITH             POINTER NUM-TO-SEND.
           PERFORM SEND-DATA.

           INITIALIZE               DATA-RECORD.
      *Replace sendername@yourdomain.xyz with your email address
           STRING  "mail from: <sendername@yourdomain.xyz>"
                   CRLF            DELIMITED BY SIZE
                   INTO             DATA-RECORD
                   WITH             POINTER NUM-TO-SEND.
           PERFORM SEND-DATA.

           INITIALIZE               DATA-RECORD.
      *Replace recepientname@yourdomain.xyz with recepient email address
           STRING  "rcpt to: <recepientname@yourdomain.xyz>"
                   CRLF            DELIMITED BY SIZE
                   INTO             DATA-RECORD
                   WITH             POINTER NUM-TO-SEND.
           PERFORM SEND-DATA.

           INITIALIZE               DATA-RECORD.
           STRING  "data"
                   CRLF            DELIMITED BY SIZE
                   INTO             DATA-RECORD
                   WITH             POINTER NUM-TO-SEND.
           PERFORM SEND-DATA.
      *Sending DATA is a one way task, no response from the server here,
      *so don't look for it either.
           MOVE    1                TO DATA-MODUS.

           INITIALIZE               DATA-RECORD.
           STRING  "Subject: From ACUCOBOL-GT with smtp"
                   CRLF            DELIMITED BY SIZE
                   INTO             DATA-RECORD
                   WITH             POINTER NUM-TO-SEND.
           PERFORM SEND-DATA.

           INITIALIZE               DATA-RECORD.
      *This is not crucial for sending, but is what is displayed in outlook,
      *makes sense to have realistic information here.
           STRING  "From: John Doe <sendername@yourdomain.xyz>"
                   CRLF
                   "To: Doe Johnson <recepientname@yourdomain.xyz>"
                   CRLF            DELIMITED BY SIZE
                   INTO             DATA-RECORD
                   WITH             POINTER NUM-TO-SEND.
           PERFORM SEND-DATA.

           INITIALIZE               DATA-RECORD.
      *CRLF . CRLF Terminates DATA INPUT
           STRING  "Using ACUCOBOL-GT and C$SOCKET"
                   CRLF
                   "."
                   CRLF
                   CRLF
                   DELIMITED        BY SIZE
                   INTO             DATA-RECORD
                   WITH             POINTER NUM-TO-SEND.
      *Now turn on status monitoring again.
           INITIALIZE               DATA-MODUS.
           PERFORM SEND-DATA.

           INITIALIZE               DATA-RECORD.
      *Closing connection, don't look for feedback
           MOVE    1                TO DATA-MODUS.
           STRING  X"1D"            DELIMITED BY SIZE
                   INTO             DATA-RECORD
                   WITH             POINTER NUM-TO-SEND.
           PERFORM SEND-DATA.

           CALL    "C$SOCKET"       USING
                   AGS-CLOSE
                   SOCKET-HANDLE.
           DISPLAY "Done - press <RETURN>" LINE 7 COL 5.
           ACCEPT  OMITTED.
           STOP RUN.

       SEND-DATA.

           SUBTRACT                 1 FROM NUM-TO-SEND.

           CALL    "C$SOCKET"       USING
                   AGS-WRITE
                   SOCKET-HANDLE
                   DATA-RECORD
                   NUM-TO-SEND.

           CALL    "C$SOCKET"       USING AGS-FLUSH
                   SOCKET-HANDLE.

           PERFORM CHECK-SOCKET.
           MOVE    1                TO NUM-TO-SEND.
           EXIT    PARAGRAPH.

       CHECK-SOCKET.

           IF      DATA-MODUS       = 1
                   EXIT             PARAGRAPH.

           MOVE    1                TO AMOUNT-READ.
           INITIALIZE               DATA-RECORD
                                    FINISHED.
           PERFORM UNTIL            FINISHED = 1

                   CALL             "C$SOCKET" USING
                                    AGS-READ
                                    SOCKET-HANDLE
                                    INPUT-CHAR
                                    1
                                    END-CALL

                   SUBTRACT         1 FROM AMOUNT-READ GIVING X

                   IF               INPUT-CHAR = X"0A"
                   AND              DATA-RECORD(X:1) = X"0D"
                                    MOVE 1 TO FINISHED
                                    SUBTRACT 1 FROM AMOUNT-READ
                                    MOVE " " TO
                                         DATA-RECORD(AMOUNT-READ:1)
                   ELSE
                                    STRING INPUT-CHAR DELIMITED BY SIZE
                                           INTO DATA-RECORD WITH POINTER
                                           AMOUNT-READ
                                    END-IF
           END-PERFORM.

           IF      AMOUNT-READ      > 0
                   DISPLAY          DATA-RECORD.

           EXIT    PARAGRAPH.

